/* Antarmuka dengan Sensor RFID - Trainer Internet of Things
 * Project : Membaca UID Kartu RFID dengan Aplikasi IoT KIT
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>
// Library LCD 16x2 I2C
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
// Library RFID MFRC522
#include <SPI.h>
#include <MFRC522.h>

// Koneksi PIN RFID ke PIN NodeMCU
// RST/Reset   RST          D0
// SPI SS      SDA(SS)      D8
// SPI MOSI    MOSI         D7 
// SPI MISO    MISO         D6
// SPI SCK     SCK          D5

#define RST_PIN D0
#define SS_PIN  D8

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// PIN Buzzer terhubung ke PIN D3 NodeMCU
#define BUZZ_PIN  D3

// Firebase objek dengan nama fbdo
FirebaseData fbdo;
// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// LCD Objek dengan nama lcd, alamat I2C 0x27, karakter 16x2
LiquidCrystal_I2C lcd(0x27,16,2);
// MFRC522 Objek dengan nama mrfc522
MFRC522 mfrc522(SS_PIN, RST_PIN);

// Variabel untuk menampung NUID kartu
String nuid;
String rfid_tag = "12e44a1b"; 

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);
  
  // Mengatur BUZZ_PIN sebagai Output
  // Kondisi awal BUZZ_PIN LOW (Buzzer OFF)
  pinMode(BUZZ_PIN, OUTPUT);
  digitalWrite(BUZZ_PIN, LOW);

  SPI.begin();        // Memulai komunikasi SPI dengan RFID
  mfrc522.PCD_Init(); // Inisialisasi RFID 
  
  lcd.init();         // Inisialisasi LCD
  lcd.backlight();    // Menyalakan Backlight LCD
  lcd.print("Trainer Kit IoT");  // Menampilkan Teks pada LCD
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);

  delay(2000);      // Jeda tampilan teks pada LCD
  lcd.clear();      // Membersihkan tampilan LCD
}

void loop() { 
  // Mencetak teks pada LCD baris pertama dan kedua
  lcd.setCursor(0,0); lcd.print("RFID READER");
  lcd.setCursor(0,1); lcd.print("NUID:");

  // Membaca dan verifikasi kartu
  if(!mfrc522.PICC_IsNewCardPresent()) { return; }
  if(!mfrc522.PICC_ReadCardSerial())   { return; }
  Serial.print("UID tag : ");
  String tag_id;

  // NUID disatukan dan disimpan pada 'tag_id'
  for(byte i = 0; i < mfrc522.uid.size; i++) {
     tag_id.concat(String(mfrc522.uid.uidByte[i], HEX));
  }
  // Menyimpan NUID ke variabel global 'nuid'
  nuid = tag_id;

  // Pencocokan NUID yang tersimpan dengan yang terbaca
  // Nada buzzer scan, kartu diterima dan ditolak 
  if(rfid_tag == nuid){
    buzz_auth();
    buzz_accepted();
  }else{
    buzz_auth();
    buzz_denied();
  }

  if(nuid){
    // Mengirim data NUID ke database
    // dengan alamat user/indicator1
    Firebase.setString(fbdo, "/" + user + "/indicator1", nuid);
  }
  
  // Mencetak NUID pada LCD dan Serial Monitor
  lcd.setCursor(5, 1); lcd.print(nuid);
  Serial.println(nuid);
}

// Fungsi Nada Buzzer scan kartu
void buzz_auth() {
  for (int x = 0; x < 8 ; x++ ) {
    digitalWrite(BUZZ_PIN, HIGH);
    delay(50);
    digitalWrite(BUZZ_PIN, LOW);
    delay(30);
    }
  delay(500);
}

// Fungsi Nada Buzzer akses diterima
void buzz_accepted() {
  for (int x = 0; x < 2 ; x++ ) {
    digitalWrite(BUZZ_PIN, HIGH);
    delay(200);
    digitalWrite(BUZZ_PIN, LOW);
    delay(100);
  }
}

// Fungsi Nada Buzzer akses ditolak
void buzz_denied() {
  digitalWrite(BUZZ_PIN, HIGH);
  delay(1000);
  digitalWrite(BUZZ_PIN, LOW);
  delay(100);
}
